use www;
SELECT 
    destination_name,
    trip_type_name,
    t.trip_number,
    trip_date,
    guide.nickname AS guide_nickname,
    guide.mobile_phone AS guide_mobile_phone,
    gear.nickname As gear_nickname,    
	gear.mobile_phone AS gear_mobile_phone, 
    '414-555-1212' AS office_phone,
    latest_guest_arrival_time,
    departure_time,
    estimated_return_time,
    gathering_point_description
FROM
    trip t
        JOIN
    destination d USING (destination_code)
        JOIN
    trip_type tt USING (trip_type_code)
        JOIN
    employee guide ON t.guide_employee_id = guide.employee_id
		LEFT JOIN
    employee gear ON t.gear_employee_id = gear.employee_id
        JOIN
    gathering_point USING (gathering_point_id)
ORDER BY destination_name , trip_type_name , trip_date
;
    