use www;
SELECT 
    destination_name,
    trip_type_name,
    t.trip_number,
    trip_date,
    guide.nickname AS guide_nickname,
	gear.nickname AS gear_nickname,
    capacity,
    COUNT(guest_id) AS guests_booked,
    capacity - COUNT(guest_id) AS positions_available
FROM
    trip t
        JOIN
    destination d USING (destination_code)
        JOIN
    trip_type tt USING (trip_type_code)
        JOIN
    employee guide ON t.guide_employee_id = guide.employee_id
		LEFT JOIN
    employee gear ON t.gear_employee_id = gear.employee_id
        LEFT JOIN
    reservation USING (trip_number)
GROUP BY trip_number
ORDER BY destination_name , trip_type_name , trip_date , trip_number
;