"""A program to discover favorable inner dimensions for a 3D printed beaker."""

from math import pi, pow

DIAMETER_IN_INCHES = 2.50
STARTING_HEIGHT_IN_INCHES = 3.25
HEIGHT_INCREMENT_IN_INCHES = 0.0625  # 1/16 inches
TARGET_VOLUME_IN_FLUID_OUNCES = 10.0
CUBIC_INCH_TO_FLUID_OUNCE_CONVERSION_FACTOR = 0.554113


def main():
    radius_in_inches = DIAMETER_IN_INCHES / 2.0
    height = STARTING_HEIGHT_IN_INCHES
    for _ in range(15):
        volume_in_cubic_inches = pi * (pow(radius_in_inches, 2) * height)
        volume_in_fluid_ounces = volume_in_cubic_inches * CUBIC_INCH_TO_FLUID_OUNCE_CONVERSION_FACTOR
        difference = volume_in_fluid_ounces - TARGET_VOLUME_IN_FLUID_OUNCES
        print(f'{height=:.4f} creates a volume that is {difference:.4f} from target volume.')
        height += HEIGHT_INCREMENT_IN_INCHES


main()
