"""
Demonstrate validation using a function.

Note that this example can be tested in two ways:

    1. By executing the main() function, entering data at the console,
       and inspecting the output.
    2. By executing the Pytest unit test
       module: test_75_validation_using_function.py.
"""


def main():
    print('Welcome to Killer Mountain!')
    print('Guests may ride this attraction if they are at least 6 years old and less than 90 years old.')
    print('Guests may ride this attraction if they weigh at least 50 pounds and less than 300 pounds.')
    age = int(input('\nPlease enter guest\'s age: '))
    weight = int(input('\nPlease enter guest\'s weight (in pounds): '))

    guest_qualified = is_qualified_guest(age, weight)

    if guest_qualified:
        print('\nThis guest may ride the attraction.')
    else:
        print('\nThis guest MAY NOT ride the attraction.')


def is_qualified_guest(age, weight):
    is_qualified = True

    if age < 6:
        is_qualified = False
    elif age >= 90:
        is_qualified = False

    if weight < 50:
        is_qualified = False
    elif weight >= 300:
        is_qualified = False

    return is_qualified


if __name__ == '__main__':
    main()
