"""Demonstration program to contrast calling functions vs calling methods."""

import math


def main():

    # int class has few user-oriented methods.
    # So calls that perform operations on ints are usually calls to functions in math package
    int_value = 4
    square_root = math.sqrt(int_value)
    print(square_root)

    # The same is true for floats.
    float_value = 3.0
    float_squared = math.pow(float_value, 2)
    print(float_squared)

    # The str class has a rich list of methods.
    # So, many string operations are method calls.
    my_string = "Hello World"
    caps_my_string = my_string.upper()
    print(caps_my_string)

    # String methods even support method chaining.
    sloppy_string = " this is a sloppy string   "
    neat_string = sloppy_string.replace('sloppy', 'neat').strip().title()
    print(neat_string)

    # Yet, some string operations are done with function calls.
    your_string = "Hello World"
    length = len(your_string)
    print(length)

    # Like str, the list class has a rich list of methods.
    # So, many list calls are method calls.
    some_list = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5]
    ones_count = some_list.count(1)
    print(ones_count)

    some_list.reverse()
    print(some_list)

    some_list.sort()
    print(some_list)

    # Yet, some list operations are done with function calls.
    other_list = ["Red", "Green", "Blue", "Yellow", "Black"]
    length_other = len(other_list)
    print(length_other)

    sorted_other = sorted(other_list)
    print(sorted_other)

    # You must rely on your memory and reference resources to get these correct.
    # There is only one general rule: if the class doesn't have a method for the
    # operation that you want to perform, then you need to find or write a function
    # to implement that operation.


main()
