"""
A refactored example program that formats phone numbers.

It uses a function to hide assumptions regarding how phone numbers are formatted.
It is the AFTER example.
"""


def main():
    first_name = 'Jane'
    middle_initial = 'Q'
    last_name = 'Scholar'
    street_1 = '1234 Main Street'
    street_2 = 'Apartment 4C'
    city = 'Glenview'
    state = 'IL'
    zipcode = '60025'
    home_phone = '8475551234'
    work_phone = '8475554321'
    mobile_phone = '8475552345'

    print(first_name, middle_initial + ".", last_name)
    print(street_1)
    print(street_2)
    print(city, state, zipcode)
    print(f'Home: {format_phone_string(home_phone)}')
    print(f'Work: {format_phone_string(work_phone)}')
    print(f'Mobile: {format_phone_string(mobile_phone)}')


def format_phone_string(phone_number):
    return f'{phone_number[0:3]}-{phone_number[3:6]}-{phone_number[6:10]}'


main()
