use www;
CREATE OR REPLACE VIEW trip_assignments_view AS
    SELECT 
        t.trip_date,
        t.trip_number,
        d.destination_name,
        tt.trip_type_name,
        COUNT(r.trip_number) AS reservation_count,
        guide.nickname AS guide_nickname,
        gear.nickname AS gear_nickname
    FROM
        trip t
            JOIN
        destination d ON t.destination_code = d.destination_code
            JOIN
        trip_type tt ON t.trip_type_code = tt.trip_type_code
            JOIN
        employee guide ON t.guide_employee_id = guide.employee_id
            LEFT JOIN
        employee gear ON t.gear_employee_id = gear.employee_id
            LEFT JOIN
        reservation r ON t.trip_number = r.trip_number
    GROUP BY trip_number;
    
SELECT 
    *
FROM
    trip_assignments_view
ORDER BY trip_date , trip_number;