use www;
SELECT 
    destination_name,
    trip_type_name,
    t.trip_number,
    trip_date,
    CONCAT(g.first_name, ' ', g.last_name) AS guest_full_name,
    experience_name,
    age,
    weight,
    CASE
        WHEN isSwimmer = 0 THEN 'False'
        WHEN isSwimmer = 1 THEN 'True'
    END AS isSwimmer,
    g.mobile_phone as guest_mobile_phone
FROM
    trip t
        JOIN
    destination d USING (destination_code)
        JOIN
    trip_type tt USING (trip_type_code)
        JOIN
    reservation r USING (trip_number)
        JOIN
    guest g USING (guest_id)
        JOIN
    experience ex USING (experience_code)
ORDER BY destination_name , trip_type_name , trip_date , guest_full_name
;
