"""This module contains Pytest unit tests for my_countries.py."""

from my_countries import Country
from pytest import approx


def test_country_constructor():
    country_name = 'Canada'
    population = 41290000
    area_in_square_miles = 3855000
    this_country = Country(country_name, population, area_in_square_miles)
    assert this_country.country_name == country_name
    assert this_country.population == population
    assert this_country.area_in_square_miles == area_in_square_miles


def test_calculate_population_density_per_square_mile():
    country_name = 'Canada'
    population = 41290000
    area_in_square_miles = 3855000
    expected_population_density_per_square_mile = round(population / area_in_square_miles)
    this_country = Country(country_name, population, area_in_square_miles)
    assert (this_country.calculate_population_density_per_square_mile() ==
            approx(expected_population_density_per_square_mile))
