"""Module contains the Country class."""

from dataclasses import dataclass


@dataclass
class Country:
    """
    A class for holding data facts regarding a country.

    Attributes:
        country_name (str): The name of the country.
        population (int): The population of the country.
        area_in_square_miles (int): The area of the country in square miles.
    """
    country_name: str
    population: int
    area_in_square_miles: int

    def calculate_population_density_per_square_mile(self):
        """
        Returns:
            (int) population density in square miles rounded to an int.
        """
        return round(self.population / self.area_in_square_miles)
