"""Contains Pytest unit tests for my_vehicles.py."""

from my_vehicles import Vehicle, Car
from pytest import approx

EXPECTED_FIRST_NAME = 'Maria'
EXPECTED_LAST_NAME = 'Gonzalez'
EXPECTED_STREET_ADDRESS_1 = '401 Splendid Way'
EXPECTED_STREET_ADDRESS_2 = 'Unit A'
EXPECTED_CITY = 'Glenview'
EXPECTED_STATE = 'IL'
EXPECTED_ZIPCODE = '60025'
EXPECTED_MAKE = 'American Auto Company'
EXPECTED_MODEL = 'Spirit'
EXPECTED_YEAR = 2020
EXPECTED_COLOR = 'White'


def test_vehicle_constructor():
    expected_vehicle_id = 'VEH123456789'
    vehicle_1 = Vehicle(EXPECTED_FIRST_NAME,
                        EXPECTED_LAST_NAME,
                        EXPECTED_STREET_ADDRESS_1,
                        EXPECTED_STREET_ADDRESS_2,
                        EXPECTED_CITY,
                        EXPECTED_STATE,
                        EXPECTED_ZIPCODE,
                        EXPECTED_MAKE,
                        EXPECTED_MODEL,
                        EXPECTED_YEAR,
                        EXPECTED_COLOR,
                        expected_vehicle_id)
    assert EXPECTED_FIRST_NAME == vehicle_1.first_name
    assert EXPECTED_LAST_NAME == vehicle_1.last_name
    assert EXPECTED_STREET_ADDRESS_1 == vehicle_1.street_address_1
    assert EXPECTED_STREET_ADDRESS_2 == vehicle_1.street_address_2
    assert EXPECTED_CITY == vehicle_1.city
    assert EXPECTED_STATE == vehicle_1.state
    assert EXPECTED_ZIPCODE == vehicle_1.zipcode
    assert EXPECTED_MAKE == vehicle_1.make
    assert EXPECTED_MODEL == vehicle_1.model
    assert EXPECTED_YEAR == vehicle_1.year
    assert EXPECTED_COLOR == vehicle_1.color
    assert expected_vehicle_id == vehicle_1.vehicle_id


def test_car_constructor():
    expected_vehicle_id = 'CAR123456789'
    expected_fuel_type = 'Electric'
    car_1 = Car(EXPECTED_FIRST_NAME,
                EXPECTED_LAST_NAME,
                EXPECTED_STREET_ADDRESS_1,
                EXPECTED_STREET_ADDRESS_2,
                EXPECTED_CITY,
                EXPECTED_STATE,
                EXPECTED_ZIPCODE,
                EXPECTED_MAKE,
                EXPECTED_MODEL,
                EXPECTED_YEAR,
                EXPECTED_COLOR,
                expected_vehicle_id,
                expected_fuel_type)
    assert EXPECTED_FIRST_NAME == car_1.first_name
    assert EXPECTED_LAST_NAME == car_1.last_name
    assert EXPECTED_STREET_ADDRESS_1 == car_1.street_address_1
    assert EXPECTED_STREET_ADDRESS_2 == car_1.street_address_2
    assert EXPECTED_CITY == car_1.city
    assert EXPECTED_STATE == car_1.state
    assert EXPECTED_ZIPCODE == car_1.zipcode
    assert EXPECTED_MAKE == car_1.make
    assert EXPECTED_MODEL == car_1.model
    assert EXPECTED_YEAR == car_1.year
    assert EXPECTED_COLOR == car_1.color
    assert expected_vehicle_id == car_1.vehicle_id
    assert expected_fuel_type == car_1.fuel_type


def test_car_determine_annual_registration_fee_fuel_type_electric():
    expected_vehicle_id = 'CAR123456789'
    expected_fuel_type = 'Electric'
    expected_annual_registration_fee = 100.00
    car_1 = Car(EXPECTED_FIRST_NAME,
                EXPECTED_LAST_NAME,
                EXPECTED_STREET_ADDRESS_1,
                EXPECTED_STREET_ADDRESS_2,
                EXPECTED_CITY,
                EXPECTED_STATE,
                EXPECTED_ZIPCODE,
                EXPECTED_MAKE,
                EXPECTED_MODEL,
                EXPECTED_YEAR,
                EXPECTED_COLOR,
                expected_vehicle_id,
                expected_fuel_type)
    assert expected_annual_registration_fee == approx(car_1.determine_annual_registration_fee())


def test_car_determine_annual_registration_fee_fuel_type_hybrid():
    expected_vehicle_id = 'CAR123456789'
    expected_fuel_type = 'Hybrid'
    expected_annual_registration_fee = 200.00
    car_1 = Car(EXPECTED_FIRST_NAME,
                EXPECTED_LAST_NAME,
                EXPECTED_STREET_ADDRESS_1,
                EXPECTED_STREET_ADDRESS_2,
                EXPECTED_CITY,
                EXPECTED_STATE,
                EXPECTED_ZIPCODE,
                EXPECTED_MAKE,
                EXPECTED_MODEL,
                EXPECTED_YEAR,
                EXPECTED_COLOR,
                expected_vehicle_id,
                expected_fuel_type)
    assert expected_annual_registration_fee == approx(car_1.determine_annual_registration_fee())


def test_car_determine_annual_registration_fee_fuel_type_fossil():
    expected_vehicle_id = 'CAR123456789'
    expected_fuel_type = 'Fossil'
    expected_annual_registration_fee = 300.00
    car_1 = Car(EXPECTED_FIRST_NAME,
                EXPECTED_LAST_NAME,
                EXPECTED_STREET_ADDRESS_1,
                EXPECTED_STREET_ADDRESS_2,
                EXPECTED_CITY,
                EXPECTED_STATE,
                EXPECTED_ZIPCODE,
                EXPECTED_MAKE,
                EXPECTED_MODEL,
                EXPECTED_YEAR,
                EXPECTED_COLOR,
                expected_vehicle_id,
                expected_fuel_type)
    assert expected_annual_registration_fee == approx(car_1.determine_annual_registration_fee())


def test_car_determine_annual_registration_fee_bad_fuel_type():
    expected_vehicle_id = 'CAR123456789'
    expected_fuel_type = 'Plutonium'
    expected_annual_registration_fee = 50.00
    car_1 = Car(EXPECTED_FIRST_NAME,
                EXPECTED_LAST_NAME,
                EXPECTED_STREET_ADDRESS_1,
                EXPECTED_STREET_ADDRESS_2,
                EXPECTED_CITY,
                EXPECTED_STATE,
                EXPECTED_ZIPCODE,
                EXPECTED_MAKE,
                EXPECTED_MODEL,
                EXPECTED_YEAR,
                EXPECTED_COLOR,
                expected_vehicle_id,
                expected_fuel_type)
    try:
        assert expected_annual_registration_fee == approx(car_1.determine_annual_registration_fee())
        assert False
    except ValueError as ve:
        assert str(ve) == 'Expected fuel type of Electric, Hybrid, or Fossil. This value is Plutonium.'
