"""Contains Pytest unit test cases for my_states.py"""

from my_states import State
from pytest import approx


def test_state_constructor():
    expected_state_name = 'Alaska'
    expected_land_area_in_square_miles = 570640.95
    expected_water_area_in_square_miles = 94743.10
    state_1 = State(expected_state_name, expected_land_area_in_square_miles, expected_water_area_in_square_miles)
    assert expected_state_name == state_1.state_name
    assert expected_land_area_in_square_miles == state_1.land_area_in_square_miles
    assert expected_water_area_in_square_miles == state_1.water_area_in_square_miles


def test_calculate_total_area_in_square_miles():
    expected_state_name = 'Alaska'
    expected_land_area_in_square_miles = 570640.95
    expected_water_area_in_square_miles = 94743.10
    expected_total_area_in_square_miles = expected_land_area_in_square_miles + expected_water_area_in_square_miles
    state_1 = State(expected_state_name, expected_land_area_in_square_miles, expected_water_area_in_square_miles)
    assert expected_total_area_in_square_miles == approx(state_1.calculate_total_area_in_square_miles())


