"""
Module contains classes for the my_vehicles application:

    Vehicle
    Car
    Truck
"""

from dataclasses import dataclass


@dataclass
class Vehicle:
    """
    A superclass that represents a vehicle.

    Note that no direct instances of Vehicle will be created.
    All instances will be created using subclasses of Vehicle.
    """
    first_name: str
    last_name: str
    street_address_1: str
    street_address_2: str
    city: str
    state: str
    zipcode: str
    make: str
    model: str
    year: int
    color: str
    vehicle_id: str


@dataclass
class Car(Vehicle):
    """A subclass of Vehicle that represents a car."""
    fuel_type: str

    def determine_annual_registration_fee(self):
        """
        Calculates annual registration fee.

        Returns:
            (float) Annual registration fee.

        Raises:
            ValueError: If fuel type has an unexpected value.
        """
        if self.fuel_type == 'Electric':
            annual_fee = 100.00
        elif self.fuel_type == 'Hybrid':
            annual_fee = 200.00
        elif self.fuel_type == 'Fossil':
            annual_fee = 300.00
        else:
            raise ValueError(f'Expected fuel type of Electric, Hybrid, or Fossil. This value is {self.fuel_type}.')
        return annual_fee


@dataclass
class Truck(Vehicle):
    """A subclass of Vehicle that represents a truck."""
    gross_weight: int

    def determine_annual_registration_fee(self):
        """
        Calculates annual registration fee.

        Returns:
            (float) Annual registration fee.
        """
        if self.gross_weight < 14001:
            annual_fee = 400.00
        else:
            annual_fee = 700.00
        return annual_fee
