"""Module contains common functions for user authentication."""

from re import search, IGNORECASE


def validate_password(candidate):
    """
    Validates a password candidate.

    Args:
        candidate (str): The candidate password:

    Returns:
        (list) error messages. List is empty if password is valid.
    """

    error_messages = []

    if len(candidate) < 6:
        error_messages.append('Password must be at least 6 characters long.')

    if not search(r'[A-Z]', candidate):
        error_messages.append('Password must include at least one upper-case letter (A-Z).')

    if not search(r'[a-z]', candidate):
        error_messages.append('Password must include at least one lower-case letter (a-z).')

    if not search(r'[!@#$%^&*]', candidate):
        error_messages.append('Password must include at least one special character (!@#$%^&*).')

    if search(r'opensesame', candidate, IGNORECASE):
        error_messages.append('Password may not contain the word "opensesame" in any case.')

    return error_messages
