"""Contains Pytest unit tests for user_authentication_common.py."""

from user_authentication_common import validate_password


def test_validate_password_meets_all_criteria():
    input_password = 'Bc&___'
    assert not validate_password(input_password)


def test_validate_password_candidate_too_short():
    input_password = 'Ab&_'
    errors = validate_password(input_password)
    assert len(errors) == 1
    assert errors[0] == 'Password must be at least 6 characters long.'


def test_validate_password_missing_uppercase_letter():
    input_password = 'ac&___'
    errors = validate_password(input_password)
    assert len(errors) == 1
    assert errors[0] == 'Password must include at least one upper-case letter (A-Z).'


def test_validate_password_missing_lowercase_letter():
    input_password = 'A&____'
    errors = validate_password(input_password)
    assert len(errors) == 1
    assert errors[0] == 'Password must include at least one lower-case letter (a-z).'


def test_validate_password_missing_multiple_criteria():
    input_password = 'a&___'
    errors = validate_password(input_password)
    assert len(errors) == 2
    assert errors[0] == 'Password must be at least 6 characters long.'
    assert errors[1] == 'Password must include at least one upper-case letter (A-Z).'


def test_validate_password_missing_special_character():
    input_password = 'Aa____'
    errors = validate_password(input_password)
    assert len(errors) == 1
    assert errors[0] == 'Password must include at least one special character (!@#$%^&*).'


def test_validate_password_contains_word_opensesame():
    input_password = 'Aa%OpenSesame'
    errors = validate_password(input_password)
    assert len(errors) == 1
    assert errors[0] == 'Password may not contain the word "opensesame" in any case.'
