"""
Reads raw data file and writes cleaned data file with both city and state coding errors cleaned.
"""
# Please DO NOT DISTRIBUTE exercise solutions

from csv import reader


def main():
    input_filename = 'data/raw_data.csv'
    output_filename = 'data/cleaned_data.csv'
    do_clean_data_coding_errors(input_filename, output_filename)


def do_clean_data_coding_errors(infile_name, outfile_name):
    with (open(infile_name, 'r', encoding='utf-8') as infile,
          open(outfile_name, 'w', encoding='utf-8') as outfile):

        the_reader = reader(infile)
        print(f'\nCleaning data records from {infile_name}')
        print('City,State,Quantity', file=outfile)
        row_number = 0
        records_processed = 0

        for row in the_reader:
            row_number += 1
            if row_number > 1:
                city_name = row[0]
                state_name = row[1]
                quantity = row[2]
                fixed_city_name = city_name.strip().title()
                output_line = f'{fixed_city_name},{state_name},{quantity}'
                print(output_line, file=outfile)
                records_processed += 1

        print(f'\n{records_processed} cleaned records were written to {outfile_name}')


if __name__ == '__main__':
    main()
