"""
Create a file of usernames from a file of person names.

This version uses tkinter-based file dialogs to get the file names from user.
"""

from tkinter.filedialog import askopenfilename, asksaveasfilename


def main():
    print("This program creates a file of usernames from a")
    print("file of person names.")

    infile_name = askopenfilename()
    outfile_name = asksaveasfilename()

    with open(infile_name, "r") as infile, open(outfile_name, "w") as outfile:
        for line in infile:
            first, last = line.split()
            username = (first[0]+last[:7]).lower()
            print(username, file=outfile)

    print("Usernames have been written to", outfile_name)


main()
