"""
Statistics library with file operations added.

Refactored for IS430 by KT.
"""

from math import sqrt
from pathlib import Path


def get_numbers():
    values_as_strings = input("Enter numbers separated by spaces and press <Enter>:\n")
    values = [float(value_as_string) for value_as_string in values_as_strings.split()]
    return values


def get_numbers_from_file(filename):
    values = []
    with open(filename, "r", encoding='utf-8') as infile:
        for line in infile:
            further_values = [float(tokens) for tokens in line.split()]
            values.extend(further_values)
    return values


def get_numbers_from_files(basedir, pattern):
    # Get all numbers from a set of files using globbing
    path = Path(basedir)
    values = []
    for filepath in path.glob(pattern):
        further_values = get_numbers_from_file(filepath)
        values.extend(further_values)
    return values


def calculate_mean(values):
    return sum(values) / len(values)


def calculate_standard_deviation(values, mean):
    squared_devs = [(value - mean) ** 2 for value in values]
    return sqrt(sum(squared_devs) / (len(values) - 1))


def calculate_median(values):
    values.sort()
    size = len(values)
    middle_position = size // 2
    if size % 2 == 0:
        med = (values[middle_position] + values[middle_position - 1]) / 2.0
    else:
        med = values[middle_position]
    return med


def main():
    print("This program computes mean, median and standard deviation")
    print("of the numbers in a file.")

    filename = input("Enter the name of the file to process: ")
    values = get_numbers_from_file(filename)
    mean = calculate_mean(values)
    standard_deviation = calculate_standard_deviation(values, mean)
    median = calculate_median(values)
  
    print("\nThe mean is", mean)
    print("The standard deviation is", standard_deviation)
    print("The median is", median)


if __name__ == '__main__':
    main()
