"""
Create a file of usernames from a file of person names.

This version creates a backup file before overwriting an existing usernames file.
"""

from pathlib import Path


def main():
    print("This program creates a file of usernames from a")
    print("file of names.")

    infile_path = Path(input("What file are the names in? "))
    outfile_path = Path(input("What file should the usernames go in? "))
    if outfile_path.exists():
        backup_path = outfile_path.with_suffix(".bak")
        print(f"Renaming existing file {outfile_path.name} to {backup_path.name}")
        outfile_path.rename(backup_path)

    with infile_path.open("r") as infile, outfile_path.open("w") as outfile:
        for line in infile:
            first, last = line.split()
            username = (first[0]+last[:7]).lower()
            print(username, file=outfile)

    print("Usernames have been written to", outfile_path)


main()

