"""This program computes mean, median and standard deviation of a series of values entered by the user."""

from math import sqrt


def main():
    print("This program computes mean, median and standard deviation.")

    values = get_numbers()
    the_mean = calculate_mean(values)
    the_standard_deviation = calculate_standard_deviation(values, the_mean)
    the_median = calculate_median(values)

    print(f"\nThe mean is {the_mean}")
    print(f"The standard deviation is {the_standard_deviation}")
    print(f"The median is {the_median}")


def get_numbers():
    these_values = []

    value_as_string = input("Enter a number (<Enter> to quit):  ")
    while value_as_string != "":
        value_as_float = float(value_as_string)
        these_values.append(value_as_float)
        value_as_string = input("Enter a number (<Enter> to quit): ")
    return these_values


def calculate_mean(values):
    total = 0.0
    for value in values:
        total += value
    return total / len(values)


def calculate_standard_deviation(values, mean):
    sum_of_deviations_squared = 0.0
    for this_value in values:
        deviation = this_value - mean
        sum_of_deviations_squared += deviation * deviation
    return sqrt(sum_of_deviations_squared / (len(values) - 1))


def calculate_median(values):
    values.sort()
    size = len(values)
    middle_position = size // 2
    if size % 2 == 0:
        median = (values[middle_position] + values[middle_position - 1]) / 2.0
    else:
        median = values[middle_position]
    return median


if __name__ == '__main__':
    main()
