"""A more pythonic version of a simple statistics library."""

from math import sqrt


def main():
    print("This program computes mean, median and standard deviation.")

    values = get_numbers()
    the_mean = calculate_mean(values)
    the_standard_deviation = calculate_standard_deviation(values, the_mean)
    the_median = calculate_median(values)

    print(f"\nThe mean is {the_mean}")
    print(f"The standard deviation is {the_standard_deviation}")
    print(f"The median is {the_median}")


def get_numbers():
    values_as_string = input("Enter numbers below separated by spaces and press <Enter>: \n")
    values = [float(value_as_string) for value_as_string in values_as_string.split()]
    return values


def calculate_mean(values):
    return sum(values) / len(values)


def calculate_standard_deviation(values, mean):
    squared_devs = [(value - mean) ** 2 for value in values]
    return sqrt(sum(squared_devs) / (len(values) - 1))


def calculate_median(values):
    values.sort()
    size = len(values)
    middle_position = size // 2
    if size % 2 == 0:
        median = (values[middle_position] + values[middle_position - 1]) / 2.0
    else:
        median = values[middle_position]
    return median


if __name__ == '__main__':
    main()
