"""
Demonstrates that lists can be created equally well with and without list comprehensions.
"""


def main():
    cities = ['Chicago, IL', 'New York, NY', 'Champaign, IL', 'Moline, IL', 'Trenton, NJ']
    print('\nOriginal List:')
    print(cities)

    print('\nSublist Derived With For-In:')
    illinois_cities = []
    for city in cities:
        if 'IL' in city:
            illinois_cities.append(city)
    print(illinois_cities)

    print('\nSublist Derived With List Comprehension:')
    illinois_cities = [city for city in cities if 'IL' in city]
    print(illinois_cities)


main()
