"""Demonstrate using a custom Python data holder class."""

from my_states import State


def main():
    print('\nCreating Wisconsin object...')
    s1 = State('Wisconsin', 150000.25, 10500.25)
    print('\nPrinting Wisconsin object using explicit call to str()...')
    print(str(s1))
    print('\nPrinting Wisconsin object using implicit call to str()...')
    print(s1)

    print('\nPrinting fields from the Wisconsin object...')
    print(s1.state_name)
    print(s1.land_area_in_square_miles)
    print(s1.water_area_in_square_miles)

    print('\nPrinting result from a method call on the Wisconsin object...')
    print(s1.calculate_total_area_in_square_miles())

    print('\nCreating a list with 3 state objects: Wisconsin, Illinois, Florida')
    s2 = State('Illinois', 100000.25, 500.25)
    s3 = State('Florida', 125000.25, 20500.25)
    states = [s1, s2, s3]
    print('Printing states in original order...')
    for state in states:
        print(state)

    print('\nSorting the list by state name...')
    states.sort(key=by_name)
    print('Printing states in name order...')
    for state in states:
        print(state)

    print('\nSorting the list by land area...')
    states.sort(key=by_land_area)
    print('Printing states in land area order...')
    for state in states:
        print(state)

    print('\nSorting the list by total area...')
    states.sort(key=by_total_area)
    print('Printing states in total area order...')
    for state in states:
        print(state)


def by_name(state_instance):
    return state_instance.state_name


def by_land_area(state_instance):
    return state_instance.land_area_in_square_miles


def by_total_area(state_instance):
    return state_instance.calculate_total_area_in_square_miles()


main()
