"""This module contains Pytest unit tests for my_states.py."""

from my_states import State
from pytest import approx


def test_state_constructor():
    land_area_in_square_miles = 50000.0
    water_area_in_square_miles = 100000.0
    s1 = State('Illinois', land_area_in_square_miles, water_area_in_square_miles)
    assert s1.state_name == 'Illinois'
    assert s1.land_area_in_square_miles == land_area_in_square_miles
    assert s1.water_area_in_square_miles == water_area_in_square_miles


def test_calculate_total_area_in_square_miles():
    land_area_in_square_miles = 50000.0
    water_area_in_square_miles = 100000.0
    s1 = State('Illinois', land_area_in_square_miles, water_area_in_square_miles)
    assert s1.calculate_total_area_in_square_miles() == approx(150000.0)
