"""
Demonstrate searching for a key in a set.

Note that use of the uszips.csv file is subject to the license shown in the
license.txt file.
"""

import csv


def main():
    valid_zipcodes = get_valid_zipcode_set()
    response = get_user_input()

    while response != '':
        if response in valid_zipcodes:
            print(f'{response} is a valid zipcode.')
        else:
            print(f'{response} is NOT a valid zipcode.')
        response = get_user_input()

    print('\nThanks for playing.')


def get_user_input():
    return input('\nPlease enter a valid 5-digit zipcode (<Enter> to stop): ')


def get_valid_zipcode_set():
    data_directory = 'data'
    zipcode_filename = 'uszips.csv'
    zipcode_file_path_and_filename = f'{data_directory}/{zipcode_filename}'
    zipcode_file = open(zipcode_file_path_and_filename, 'r', encoding='utf-8')
    zipcode_reader = csv.reader(zipcode_file)
    next(zipcode_reader)
    zipcodes = set()  # note that you cannot create an empty set using just {}
    for row in zipcode_reader:
        zipcode, *rest = row
        zipcodes.add(zipcode)
    zipcode_file.close()
    return zipcodes


main()
