"""This module contains Pytest unit tests for _80_validation_using_function_and_messages.py"""

from _80_validation_using_function_and_messages import check_guest_qualifications


def test_check_guest_qualifications_at_lower_boundary_age():
    messages = check_guest_qualifications(6, 100)
    assert not messages


def test_check_guest_qualifications_at_upper_boundary_age():
    messages = check_guest_qualifications(89, 100)
    assert not messages


def test_check_guest_qualifications_below_lower_boundary_age():
    messages = check_guest_qualifications(5, 100)
    assert len(messages) == 1
    assert messages[0] == 'Guests must be at least 6 years old.'


def test_check_guest_qualifications_above_upper_boundary_age():
    messages = check_guest_qualifications(90, 100)
    assert len(messages) == 1
    assert messages[0] == 'Guests must be no more than 89 years old.'


def test_check_guest_qualifications_at_lower_boundary_weight():
    messages = check_guest_qualifications(6, 50)
    assert not messages


def test_check_guest_qualifications_at_upper_boundary_weight():
    messages = check_guest_qualifications(6, 299)
    assert not messages


def test_check_guest_qualifications_below_lower_boundary_weight():
    messages = check_guest_qualifications(6, 49)
    assert len(messages) == 1
    assert messages[0] == 'Guests must weigh at least 50 pounds.'


def test_check_guest_qualifications_above_upper_boundary_weight():
    messages = check_guest_qualifications(6, 300)
    assert len(messages) == 1
    assert messages[0] == 'Guests must weigh less than 300 pounds.'


def test_check_guest_qualifications_with_more_than_one_error():
    messages = check_guest_qualifications(5, 300)
    assert len(messages) == 2
    assert messages[0] == 'Guests must be at least 6 years old.'
    assert messages[1] == 'Guests must weigh less than 300 pounds.'
