"""This module contains Pytest unit test cases for _35_nested_ifs_in_function.py."""

from _35_nested_ifs_in_function import determine_premium
from pytest import approx


def test_determine_premium_24_male():
    assert determine_premium(24, 'male') == approx(200.00)


def test_determine_premium_25_male():
    assert determine_premium(25, 'male') == approx(160.00)


def test_determine_premium_24_female():
    assert determine_premium(24, 'female') == approx(100.00)


def test_determine_premium_25_female():
    assert determine_premium(25, 'female') == approx(70.00)


def test_determine_premium_29_nonbinary():
    gender = 'nonbinary'
    try:
        assert determine_premium(29, gender) == approx(0.0)
        assert False
    except ValueError as ve:
        error_message = f'Gender coded as "{gender}". We were not expecting this value. Please contact the IT department!'
        assert str(ve) == error_message
