"""
Demonstrate a simple lookup using structural pattern matching in a function.

Note that this module does not have a main() function.
"""


def lookup_region_name(region_code):
    match region_code:
        case 1:
            region_name = 'Northeast'
        case 2:
            region_name = 'Southeast'
        case 3:
            region_name = 'Northwest'
        case 4:
            region_name = 'Southwest'
        case _:
            raise ValueError(f'Region code must be 1, 2, 3, or 4. This value is {region_code}.')
    return region_name
