"""This module contains Pytest unit test cases for _45_raise.py."""

from _92_lookup_in_function_using_structural_pattern_matching import lookup_region_name


def test_lookup_region_name_for_northeast():
    assert lookup_region_name(1) == 'Northeast'


def test_lookup_region_name_for_southeast():
    assert lookup_region_name(2) == 'Southeast'


def test_lookup_region_name_for_northwest():
    assert lookup_region_name(3) == 'Northwest'


def test_lookup_region_name_for_southwest():
    assert lookup_region_name(4) == 'Southwest'


def test_lookup_region_name_below_lower_boundary():
    region_code = 0
    try:
        _ = lookup_region_name(region_code)
        assert False
    except ValueError as ve:
        error_message = f'Region code must be 1, 2, 3, or 4. This value is {region_code}.'
        assert str(ve) == error_message


def test_lookup_region_name_above_upper_boundary():
    region_code = 5
    try:
        _ = lookup_region_name(region_code)
        assert False
    except ValueError as ve:
        error_message = f'Region code must be 1, 2, 3, or 4. This value is {region_code}.'
        assert str(ve) == error_message
