"""Determine CSV file column index numbers based upon CSV file header row values."""

from csv import reader


INFILE_NAME = 'data/MuseumFile2018_File1_Nulls.csv'


def main():
    with open(INFILE_NAME, 'r', encoding='utf-8') as infile:
        this_reader = reader(infile)
        header_row = next(this_reader)
        print(f'\nColumn Index Numbers for Columns in {INFILE_NAME}')
        print(f'{"\nCOLIDX":>3}    {"COLNAME":<10}')
        for i in range(len(header_row)):
            print(f'{i:>3}       {header_row[i]:<10}')


main()
