"""Prints name and address list for qualifying museums in the input CSV file."""

from csv import reader

INFILE_NAME = 'data/MuseumFile2018_File2_Nulls.csv'
QUALIFYING_STATE_CODES = {'IL', }


def main():
    with open(INFILE_NAME, 'r', encoding='cp1252') as infile:
        infile_reader = reader(infile)
        input_count = 0
        printed_count = 0
        row_count = 0

        for row in infile_reader:
            row_count += 1
            if row_count > 1:
                input_count += 1
                common_name = row[7]
                street = row[11]
                city = row[12]
                state = row[13]
                zipcode = row[14]
                if state.upper() in QUALIFYING_STATE_CODES:
                    printed_count += 1
                    print(f'\n{common_name}')
                    print(f'{street}')
                    print(f'{city}, {state} {zipcode}')

    print(f'\n{input_count:,} museum records were read from {INFILE_NAME}.')
    print(f'{printed_count:,} qualifying museum records were printed.')


main()
