"""Counts the number of input records that include the color purple."""


def main():
    infile_name = 'data/slot_values.txt'
    do_purple_counter(infile_name)


def do_purple_counter(infile_name):
    with open(infile_name, 'r', encoding='utf-8') as infile:
        purple_count = 0
        for line in infile:
            slot_values = line.split()
            if 'Purple' in slot_values:
                purple_count += 1
    print(f'\nThere were {purple_count:,} records in the input file that included the color purple.')


if __name__ == '__main__':
    main()
